// Quick Recorder Pin.js

function buildUI( tag ) {
	
  tag.addParameterSeparator("Settings");
  
  tag.addParameterBool("recursive", 1, 0, 1, false, false);
  
  tag.addParameterBool("record position", 0, 0, 1, false, false);
  tag.addParameterBool("record rotation", 1, 0, 1, false, false);
  tag.addParameterBool("record scale", 0, 0, 1, false, false);
  
  tag.addParameterSeparator("Custom Prameter Name(s)");
  
  tag.addParameterString("record names", "", false);
  tag.addParameterButton("check parameter name", "check", "checkParameterName");
  
  tag.addParameterSeparator("F-Curve type");
  
  tag.addParameterSelector("curve type", ["SOFT", "SPLINE", "FLAT", "LINEAR"], false);
}

function checkParameterName( tag ) {
  var obj = tag.owner();
  
  if (obj) {
    var info = obj.parameterInfo();
    
    var str = '';
    for(var i = 0;i < info.length;i++) {
      str += info[i][0] + " ["+info[i][1]+"] " + "\n";
    }
    
    OS.messageBox( "Parameter Names", str );
  }
}